unit LabEdit;
interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls;

type
  TLabEdit = class(TWinControl)
  private
    procedure WMSize(var Message:TMessage); message WM_SIZE;
    procedure CimkeBe(const s : String);
    procedure SzovegBe(const s : String);
    function CimkeKi : String;
    function SzovegKi : String;
  public
    constructor Create(AOwner: TComponent); override;
  published
    cEdit  : TEdit;
    cLabel : TLabel;
    property ESzoveg :  String read SzovegKi write SzovegBe ;
    property ECimke  :  String read CimkeKi write CimkeBe ;
    property Font;
    property Color;
  end;

procedure Register;

implementation
constructor TLabEdit.Create(AOwner: TComponent);
begin
  inherited;
  cLabel:=TLabel.Create(Self);
  cLabel.Parent:=Self;
  cEdit:=TEdit.Create(Self);
  cEdit.Parent:=Self;
  Self.Width:=cEdit.Width+cLabel.width+5;
  Self.Height:=cEdit.height;
  ECimke:='cmke';
  ESzoveg:='szveg';
end;

procedure TLabEdit.WMSize(var Message:TMessage);
begin
  Inherited;
  with cLabel do
  begin
    Autosize:=true;
    Caption:=Ecimke;
    Height:=self.Height;
    Left:=0;
    Top:=3;
    Refresh;
  end;
  with cEdit do
  begin
   Width:=self.width-5-cLabel.width;
   Left:=cLabel.width+5;
   Height:=self.Height;
   Top:=0;
   Text:=ESzoveg;
  end;
end;

procedure TLabEdit.CimkeBe(const s : String);
begin
  cLabel.Caption:=s;
end;

procedure TLabEdit.SzovegBe(const s : String);
begin
  cEdit.Text:=s;
end;

function TLabEdit.CimkeKi : String;
begin
  result:=CLabel.caption;
end;

function TLabEdit.SzovegKi : String;
begin
  result:=CEdit.text;
end;


procedure Register;
begin
  RegisterComponents('Samples', [TLabEdit]);
end;

end.
